<?php

// fix-storage.php
// Run this once from your browser: https://yourdomain.com/fix-storage.php

$publicStorage = __DIR__ . '/public/storage';
$target = __DIR__ . '/storage/app/public';

echo "<pre>";

if (is_link($publicStorage) || file_exists($publicStorage)) {
    echo "✔ The public/storage symlink or folder already exists.\n";
    exit;
}

try {
    // Try to create symlink
    if (symlink($target, $publicStorage)) {
        echo "✅ Symlink created: public/storage → storage/app/public\n";
    } else {
        throw new Exception("Symlink function failed (maybe disabled on hosting).");
    }
} catch (Exception $e) {
    echo "⚠ Failed to create symlink: " . $e->getMessage() . "\n";

    // Fallback: copy files instead
    echo "➡ Copying files instead...\n";
    recursiveCopy($target, $publicStorage);
    echo "📂 Files copied to public/storage\n";
}

function recursiveCopy($src, $dst)
{
    $dir = opendir($src);
    @mkdir($dst, 0777, true);

    while (false !== ($file = readdir($dir))) {
        if ($file != '.' && $file != '..') {
            if (is_dir($src . '/' . $file)) {
                recursiveCopy($src . '/' . $file, $dst . '/' . $file);
            } else {
                copy($src . '/' . $file, $dst . '/' . $file);
            }
        }
    }

    closedir($dir);
}

echo "Done ✅\n";
