<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class FixStorageSymlink extends Command
{
    protected $signature = 'storage:fix-link';
    protected $description = 'Fix the public/storage symlink for cPanel or shared hosting';

    public function handle()
    {
        $publicStorage = public_path('storage');
        $target = storage_path('app/public');

        if (is_link($publicStorage) || file_exists($publicStorage)) {
            $this->info("✔ The storage symlink already exists.");
            return 0;
        }

        try {
            // Attempt symlink
            symlink($target, $publicStorage);
            $this->info("✅ Symlink created: $publicStorage → $target");
        } catch (\Exception $e) {
            $this->error("⚠ Failed to create symlink: " . $e->getMessage());

            // Fallback: copy files instead
            $this->warn("Attempting fallback copy…");
            $this->recursiveCopy($target, $publicStorage);
            $this->info("📂 Files copied to $publicStorage");
        }

        return 0;
    }

    private function recursiveCopy($src, $dst)
    {
        $dir = opendir($src);
        @mkdir($dst, 0777, true);

        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    $this->recursiveCopy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }

        closedir($dir);
    }
}
